package awt;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

import img.Argb;
import img.PixImage;


public class ExchangeImageAWT {
/**
 * @param buffer
 * @param width
 * @return
 */

	public static BufferedImage getImage(int[] buffer,int width){
		//buffer argb
		int height=buffer.length/width;

		BufferedImage image
		   = new BufferedImage( width, height, BufferedImage.TYPE_INT_ARGB );
		WritableRaster raster = image.getRaster();
		DataBufferInt buf = (DataBufferInt)(raster.getDataBuffer());

		for(int i=0;i<buffer.length;i++) {
			buf.setElem(i,buffer[i]);
		}
		return image;
	}
	public static BufferedImage getImageRGB(int[] buffer,int width){
		//buffer argb
		int height=buffer.length/width;

		BufferedImage image
		   = new BufferedImage( width, height, BufferedImage.TYPE_INT_RGB );
		WritableRaster raster = image.getRaster();
		DataBufferInt buf = (DataBufferInt)(raster.getDataBuffer());

		for(int i=0;i<buffer.length;i++) {
			buf.setElem(i, 0x00ffffff & buffer[i]);//cut alpha
		}
		return image;
	}
	public static PixImage getPixImage(BufferedImage image){
		int w = image.getWidth();
		int[] pixel=null;
        DataBuffer buf = image.getRaster().getDataBuffer();

        //to int
        if(buf.getDataType() == DataBuffer.TYPE_INT){

            pixel = ((DataBufferInt)buf).getData();
        }else if(buf.getDataType() == DataBuffer.TYPE_BYTE){

    		byte[] bytePixel = ((DataBufferByte)buf).getData();
        	int h = image.getHeight();
        	int channel = bytePixel.length / (w*h);
        	
        	switch(channel) {
        	case 1 :
        		//GrayScale
        		pixel = byte1toInt(bytePixel);
        		break;
        	case 3 :
        		//BGR
        		pixel = byte3toInt(bytePixel);
        		break;
        	case 4 :
        		//ABGR
                pixel = byte4toInt(bytePixel);
        		break;
        	}
        }
		return new PixImage(pixel,w);
	}
	public static int[] byte1toInt(byte[] array) {
		/**
		 * DataBufferByte GRAY
		 * 0XFFRGB
		 */
		int[] intArray = new int[array.length];
		for(int i=0;i<array.length;i++) {
			
			int temp = 0xff & array[i];
			intArray[i] = Argb.argb(0xff, temp, temp, temp);
		}
		return intArray;
	}
	public static int[] byte3toInt(byte[] array) {
		/**
		 * DataBufferByte BGR
		 * 0XFFRGB
		 */
		int[] intArray = new int[array.length/3];
		int r=0;
		int g=0;
		int b=0;

		for(int i=0;i<array.length;i++) {

			int temp = 0xff& array[i];

			switch(i%3) {
			case 0:
				b=temp;
				break;
			case 1:
				g=temp;
				break;
			case 2:
				r=temp;
				intArray[i/3]=Argb.argb(0xff,r,g,b);
				break;
			}
		}
		return intArray;
	}
	public static int[] byte4toInt(byte[] array) {
		/**
		 * DataBufferByte ABGR
		 */
		int[] intArray = new int[array.length/4];
		int a=0;
		int r=0;
		int g=0;
		int b=0;

		for(int i=0;i<array.length;i++) {

			int temp = 0xff& array[i];

			switch(i%4) {
			case 0:
				a=temp;
				break;
			case 1:
				b=temp;
				break;
			case 2:
				g=temp;
				break;
			case 3:
				r=temp;
				intArray[i/4]=Argb.argb(a,r,g,b);
				break;
			}
		}
		return intArray;
	}
}
