package img;

public class Argb {
	/**
	 *
	 *
	 * @param argb 255,255,255,255
	 *	
	 *
	 * @return
	 */
	public static int INVISIBLE_WHITE = 0x00ffffff;// 透明白
    public static int alpha(int argb){
        return argb>>>24;
    }
    public static int red(int argb){
        return argb>>16&0xff;
    }
    public static int green(int argb){
        return argb>>8&0xff;
    }
    public static int blue(int argb){
        return argb&0xff;
    }
    public static int toArgb(int rgb){

    	return rgb|0xff000000;
    }
    public static int rgb(int r,int g,int b){
        return 0xff000000 | r <<16 | g <<8 | b;
    }
    public static int argb(int a,int r,int g,int b){
        return a<<24 | r <<16 | g <<8 | b;
    }
    public static String toString(int argb){
    	String str=
    		alpha(argb)+","+
    		red(argb)+","+
    		green(argb)+","+
    		blue(argb);
        return str;
    }
    public static int rap(int rap_color, int base_color){
    	//透過
		if(Argb.alpha(rap_color)==0xff) {
			//不透明
			return rap_color;
		}else if(Argb.alpha(rap_color)==0x00){
			//透明
			return base_color;
		}else {
			//混色
			double rap_rate = (double)Argb.alpha(rap_color)/0xff;
			double rap_red  = Argb.red(rap_color)*rap_rate;
			double rap_green= Argb.green(rap_color)*rap_rate;
			double rap_blue = Argb.blue(rap_color)*rap_rate;

			double base_rate = 1-rap_rate;//base_color　は透過しない。
			double base_red  = Argb.red(base_color)*base_rate;
			double base_green= Argb.green(base_color)*base_rate;
			double base_blue = Argb.blue(base_color)*base_rate;

			return Argb.argb(
					0xff,
					(int)(rap_red+base_red),
					(int)(rap_green+base_green),
					(int)(rap_blue+base_blue));
		}

    }
}
