package img;

import java.util.ArrayList;

import point.Compass;
import point.Point_dou;

public class PixImage{
	/**
	 *
	 * width（折り返し幅）で、2元配列を表す1元配列。
	 * subimage　で、サブ配列を取り出す
	 * 
	 * IndexOutOfBoundsException
	 * ArrayIndexOutOfBoundsException
	 *
	 */
	private int[] buffer;//pixel
	private int width;
	private String name=null;
	
	static int[] toXY(int no, int width) {
		int[] xy={no%width,	no/width};
		return xy;
	}
	
	static int toNo(int x, int y, int width) {
		if(width>x && x>=0) {
			return y*width +x;
		}else {
			throw new RuntimeException("out of X_range.");
		}
	}

	public PixImage(int[] buffer,int width){
		this.buffer=buffer;
		this.width=width;
	}

	public PixImage(int width,int height){
		buffer= new int[width*height];
		this.width=width;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public int[] getBuffer(){
		return buffer;
	}
	public int getWidth(){
		return width;
	}
	public int getHeight(){
		return buffer.length/width;
	}
	public int getPix(int pixNum) {
		try {
			return buffer[pixNum];
		}catch(RuntimeException e) {
			return Argb.INVISIBLE_WHITE;
		}
	}
	
	public int getPix(int x, int y) {
		try {
			return buffer[toNo(x, y, width)];
		}catch(RuntimeException e) {
			return Argb.INVISIBLE_WHITE;
		}
	}
	public void setPix(int x, int y, int value) {
		try {
			buffer[toNo(x, y, width)] = value;
		}catch(RuntimeException e) {
		}
	}
	public void rapPix(int x, int y, int rap_color) {
		try {
			int no = toNo(x, y, width);
			buffer[no] = Argb.rap(rap_color, buffer[no]);
		}catch(RuntimeException e) {
			return;
		}
	}
	
	public PixImage clone() {
		return new PixImage(buffer, width);
	}
	
	//paint
	public void fill(int color){

		fill(this, color);
	}
	public static void fill(PixImage pimg, int color){

		for(int i=0; i<pimg.buffer.length; i++) {
			pimg.buffer[i] = color;
		}
	}
	
	public void waku(int color){

		waku(this, color);
	}
	public static void waku(PixImage pimg, int color){

		for(int x=0; x<pimg.width; x++) {
			pimg.buffer[toNo(x,0,pimg.width)]= color;
			pimg.buffer[toNo(x,pimg.getHeight()-1,pimg.width)]= color;
		}
		for(int y=0;y<pimg.getHeight();y++){
			pimg.buffer[toNo(0,y,pimg.width)]= color;
			pimg.buffer[toNo(pimg.width-1,y,pimg.width)]= color;

		}
	}
	public void waku(int color, int stroke){

		waku(this, color, stroke);
	}
	public static void waku(PixImage pimg, int color, int stroke){

		for(int x=0; x<pimg.width; x++) {
			for(int i=0; i<stroke; i++) {
				pimg.buffer[toNo(x,i,pimg.width)]= color;
				pimg.buffer[toNo(x, pimg.getHeight()-1-i, pimg.width)]= color;
			}
		}
		for(int y=0; y<pimg.getHeight(); y++){
			for(int i=0; i<stroke; i++) {
				pimg.buffer[toNo(i,y,pimg.width)]= color;
				pimg.buffer[toNo(pimg.width-1-i,y,pimg.width)]= color;
			}
		}
	}
	
	
	public void fillRect(int start_X,int start_Y,int rectWidth,int rectHeight,int color){

		fillRect(this, start_X, start_Y, rectWidth, rectHeight, color);
	}
	public static void fillRect(PixImage pimg, int start_X,int start_Y,int rectWidth,int rectHeight,int color){

		if(start_X>=pimg.width || start_Y>=pimg.getHeight())return;
		if(start_X+rectWidth<0 || start_Y+rectHeight<0)return;
		
		if(start_X<0) {
			rectWidth += start_X;
			start_X = 0;
		}
		if(start_X+rectWidth>pimg.width) {
			rectWidth = pimg.width - start_X;
		}

		if(start_Y<0) {
			rectHeight += start_Y;
			start_Y = 0;
		}
		if(start_Y+rectHeight>pimg.getHeight()) {
			rectHeight = pimg.getHeight() - start_Y;
		}
		
		for(int x=start_X ; x<(start_X+rectWidth) ;x++) {
			 for(int y=start_Y ; y<(start_Y+rectHeight) ;y++){
				 pimg.setPix(x, y, color);
			 }
		}
	}
	
	public void strokeRect(int start_X, int start_Y, int rectWidth, int rectHeight, int color){

		strokeRect(this, start_X, start_Y, rectWidth, rectHeight, color);
	}
	public static void strokeRect(PixImage pimg, int start_X, int start_Y, int rectWidth, int rectHeight, int color){

		for(int x=start_X ; x<(start_X+rectWidth) ;x++) {
			pimg.setPix(x, start_Y, color);
			pimg.setPix(x, start_Y + rectHeight, color);
		}
		 for(int y=start_Y ; y<(start_Y+rectHeight) ;y++){	
			 pimg.setPix(start_X, y, color);
			 pimg.setPix(start_X + rectWidth-1, y, color);
		 }
	}
	public void strokeRect(int start_X, int start_Y, int rectWidth, int rectHeight, int color, int stroke){

		strokeRect(this, start_X, start_Y, rectWidth, rectHeight, color, stroke);
	}
	public static void strokeRect(PixImage pimg, int start_X, int start_Y, int rectWidth, int rectHeight, int color, int stroke){

		if(start_X>=pimg.width || start_Y>=pimg.getHeight())return;
		if(start_X+rectWidth<0 || start_Y+rectHeight<0)return;
		
		for(int x=start_X ; x<(start_X+rectWidth) ;x++) {
			for(int i=0; i<stroke; i++) {
				pimg.setPix(x, start_Y +i, color);
				pimg.setPix(x, start_Y + rectHeight -i, color);
			}

		}
		 for(int y=start_Y ; y<(start_Y+rectHeight) ;y++){
			for(int i=0; i<stroke; i++) {
				pimg.setPix(start_X +i, y, color);
				pimg.setPix(start_X + rectWidth-1 -i, y, color);
			}
		 }
	}
	public static void line(PixImage pimg, Point_dou p1, Point_dou p2, int color) {
		line(pimg, p1.getX(), p1.getY(), p2.getX(), p2.getY(), color);
	}
	public static void line(PixImage pimg, double x1, double y1, double x2, double y2, int color) {

		double a = (y1-y2)/(x1-x2);
		double b = y1-a*x1;
		
		double minY;
		double maxY;
		
		if(x1==x2) {
			
			minY = Math.min(y1, y2);
			maxY = Math.max(y1, y2);
			int x = (int)Math.round(x1);
			for(int i=(int)minY; i<=maxY; i++) {
				pimg.rapPix(x, i, color);
			}
			
		}else if(Math.abs(a)>1) {
			
			minY = Math.min(y1, y2);
			maxY = Math.max(y1, y2);
			for(int i=(int)minY; i<=maxY; i++) {
				pimg.rapPix((int)Math.round((i-b)/a), i, color);
			}
			
		}else {
			
			double minX;
			double maxX;
			minX = Math.min(x1, x2);
			maxX = Math.max(x1, x2);
			for(int i=(int)minX; i<=maxX; i++) {
				pimg.rapPix(i, (int)Math.round(a*i+b), color);
			}
			
		}
	}
	public void fillOval(double redius, int color){
		int center_x = width/2;
		int center_y = getHeight()/2;
		fillOval(center_x, center_y, redius, color);
	}
	public void fillOval(int center_x, int center_y, double redius, int color){

		fillOval(this, center_x, center_y, redius, color);
	}

	public static void fillOval(PixImage pimg, int center_x, int center_y, double redius, int color){

		int intRedius45do = (int)Math.round(redius/1.414);
		
		for(int x=0; x<intRedius45do; x++) {
			
			double dou_height_1 = Math.sqrt(redius*redius - x*x);
			dou_height_1-=0.2;//ajust
			int height_1 = (int)Math.round(dou_height_1);
			
		
			for(int y= 0; y<=height_1; y++) {

				pimg.rapPix( x+center_x, y+center_y, color);
				if(x!=0) {
					pimg.rapPix(-x+center_x, y+center_y, color);
				}
				if(y!=0) {
					pimg.rapPix( x+center_x, -y+center_y, color);
				}
				if(x!=0&&y!=0) {
					pimg.rapPix(-x+center_x, -y+center_y, color);
				}
				
			}
						
		}
		for(int y=0; y<intRedius45do; y++) {		
			double dou_x_1 = Math.sqrt(redius*redius - y*y);
			dou_x_1-=0.2;//ajust
			int width_1 = (int)Math.round(dou_x_1);
			
			for(int x= intRedius45do; x<= width_1; x++) {
				pimg.rapPix( x+center_x, y+center_y, color);
				pimg.rapPix(-x+center_x, y+center_y, color);
				
				if(y!=0) {
					pimg.rapPix( x+center_x, -y+center_y, color);
					pimg.rapPix(-x+center_x, -y+center_y, color);
				}
			}
		}
	}
	
	public void fillOval(int center_x, int center_y, double redius_1, double redius_0, int color){

		fillOval(this, center_x, center_y, redius_1, redius_0, color);
	}
	public static void fillOval(PixImage pimg, int center_x, int center_y, double redius_1, double redius_0, int color){

		int intRedius45do = (int)Math.round(redius_1/1.414);
		
		for(int x=0; x<intRedius45do; x++) {
			
			double dou_height_1 = Math.sqrt(redius_1*redius_1 - x*x);
			dou_height_1-=0.2;//ajust
			int height_1 = (int)Math.round(dou_height_1);
			
			double dou_height_0 = Math.sqrt(redius_0*redius_0 - x*x);
			dou_height_0-=0.2;//ajust
			int height_0 = (int)Math.round(dou_height_0);
			
			height_0 = height_0>0 ? height_0 : 0;
		
			for(int y= height_0; y<=height_1; y++) {

				pimg.rapPix( x+center_x, y+center_y, color);
				if(x!=0) {
					pimg.rapPix(-x+center_x, y+center_y, color);
				}
				if(y!=0) {
					pimg.rapPix( x+center_x, -y+center_y, color);
				}
				if(x!=0&&y!=0) {
					pimg.rapPix(-x+center_x, -y+center_y, color);
				}
				
			}
						
		}
		for(int y=0; y<intRedius45do; y++) {		
			double dou_x_1 = Math.sqrt(redius_1*redius_1 - y*y);
			dou_x_1-=0.2;//ajust
			int width_1 = (int)Math.round(dou_x_1);
			
			double dou_x_0 = Math.sqrt(redius_0*redius_0 - y*y);
			int width_0 = (int)Math.round(dou_x_0);
			
			width_0 = intRedius45do<width_0 ? width_0 : intRedius45do;

			for(int x= width_0; x<= width_1; x++) {
				pimg.rapPix( x+center_x, y+center_y, color);
				pimg.rapPix(-x+center_x, y+center_y, color);
				
				if(y!=0) {
					pimg.rapPix( x+center_x, -y+center_y, color);
					pimg.rapPix(-x+center_x, -y+center_y, color);
				}
			}
		}
	}
	
	public void strokeOval(double redius,int color){
		//center
		strokeOval(width/2, getHeight()/2, redius, color);
	}
	public void strokeOval(int center_x, int center_y, double redius, int color){

		strokeOval(this, center_x, center_y, redius, color);
	}
	public static void strokeOval(PixImage pimg, int center_x, int center_y, double redius, int color){

		int intRedius45do = (int)Math.round(redius/1.414);
		
		for(int x= -intRedius45do; x<=0; x++) {		
			double dou_y = Math.sqrt(redius*redius - x*x);
			dou_y-=0.2;//ajust

			//general
			pimg.setPix( x+center_x,  (int)Math.round(dou_y) + center_y, color);
			pimg.setPix( x+center_x, -(int)Math.round(dou_y) + center_y, color);
			pimg.setPix(-x+center_x,  (int)Math.round(dou_y) + center_y, color);
			pimg.setPix(-x+center_x, -(int)Math.round(dou_y) + center_y, color);
			
		}
		for(int y= -intRedius45do; y<=0; y++) {		
			double dou_x = Math.sqrt(redius*redius - y*y);
			dou_x-=0.2;//ajust
			int int_x = (int)Math.round(dou_x);
			
			//general
			pimg.setPix( int_x + center_x,  y+center_y, color);
			pimg.setPix(-int_x + center_x,  y+center_y, color);
			pimg.setPix( int_x + center_x, -y+center_y, color);
			pimg.setPix(-int_x + center_x, -y+center_y, color);			
		}
	}
	
	
    public PixImage replace(int srcColor, int trgColor){
    	/**
    	 * Color srcColor を trgColor に置き換える
    	 */
    	PixImage cloneImg = clone();
    	replace(cloneImg, srcColor, trgColor);

		return cloneImg;
    }
    public static void replace(PixImage pimg, int srcColor,int trgColor ){
    	/**
    	 * Color srcColor を trgColor に置き換える
    	 */
        for(int i=0;i<pimg.buffer.length;i++){
        	if(pimg.buffer[i]==srcColor){
        		pimg.buffer[i]=trgColor;
        	}
        }
    }
	public PixImage Alfa(int alpha){
    	/**
    	 * 透明値　をalphaにする。
    	 */
		PixImage cloneImg = clone();
		Alfa(cloneImg, alpha);
		
		return cloneImg;
		
	}
	public static void Alfa(PixImage pimg, int alpha){
    	/**
    	 * 透明値　をalphaにする。
    	 */
		for(int i=0;i<pimg.buffer.length;i++){

			int argb = pimg.buffer[i];
    		int a = Argb.alpha(argb);//
	        int rgb = argb & Argb.INVISIBLE_WHITE;

	        int newAlfa=a<alpha?a:alpha; //take smaller
	        if(newAlfa<0)newAlfa=0;
	        if(newAlfa>255)newAlfa=255;
	        newAlfa = newAlfa << 24;
	        int newArgb = rgb |newAlfa;
	        pimg.buffer[i]= newArgb;

		}
	}
	

    public PixImage rotate(double angle) {

    	int[] newBuffer=new int[buffer.length];//result
    	//XY　入れ替えなし


    	for(int i=0; i<newBuffer.length; i++) {

    		int tarX=i%width;
    		int tarY=i/width;

    		Point_dou rotatePoint= Compass.rotate(tarX, tarY, width/2, getHeight()/2, -angle);

    		int x= (int) Math.round(rotatePoint.getX());
    		int y= (int) Math.round(rotatePoint.getY());
    		newBuffer[i] = getPix(x, y);
    		
    	}

    	//buffer= newBuffer;

    	return new PixImage(newBuffer,width);
    }
    public PixImage Size(int magX, int magY ){
    	/**
    	 * 拡大
    	 */

    	int[] newBuffer = new int[buffer.length*magX*magY];
    	int newWidth=width*magX;
    	int trg_pos=0;//newBuffer　の符数

    	for(int src_pos=0;src_pos<buffer.length;src_pos++) {
    		int x=src_pos%width; //2元配列にした場合の幅方向位置

    		ArrayList<Integer> temp = new ArrayList<Integer>();//width 方向に拡大した1行を保持
    		do{
    			//width 拡大
        		for(int w=0;w<magX;w++) {
            		temp.add(buffer[src_pos]);
        		}
        		src_pos++;
        		x=src_pos%width;
    		}while(x!=0) ;

    		//height 拡大
    		for(int h=0;h<magY;h++) {
        		for(int temp_i=0;temp_i<temp.size();temp_i++) {
            		newBuffer[trg_pos++]=temp.get(temp_i);
        		}
    		}
    		src_pos--;
    	}

    	//width = newWidth;
    	//buffer= newBuffer;

    	return new PixImage(newBuffer,newWidth);
    }

	public PixImage subimage(int start_X,int start_Y,int Width,int Height){
		/**
		 * イメージの一部を切り出します。
		 * 範囲外は、透明色で埋めます
		 */
		int[] newBuffer=new int[Width*Height];
		int i=0;
		for(int y=start_Y; y<(start_Y+Height); y++){
			if(y>-1 && y<getHeight()) {
				//高さが画面内
				int h=this.width*y;
				for(int x=start_X; x<(start_X+Width); x++){
					if(x>-1 && x<width) {
						//幅が画面内
						newBuffer[i]=buffer[h+x];
					}else {
						//幅が画面外
						newBuffer[i]=Argb.INVISIBLE_WHITE;//透明色
					}
					i++;
				}
			}else {
				//高さが画面外
				for(int x=start_X;x<(start_X+Width);x++){
					newBuffer[i]=Argb.INVISIBLE_WHITE;//透明色
					i++;
				}
			}
		}

		return new PixImage(newBuffer, Width);
	}
	//drawImage
	public void drawImage(PixImage rap_img,int start_x,int start_y){
		/**
		 * イメージを書き込みます。（上書き）
		 */

		//貼り付け画像
		int rapWidth = rap_img.getWidth();
		int rapHeight = rap_img.getHeight();
		int rap_x = 0;
		int rap_y = 0;

		//基礎画像
		int bas_x=0;
		int bas_y=0;

		//共通(貼り付けサイズ)
		int area_width=0;
		int area_height=0;

		//開始位置算出
		if(start_x<0) {
			rap_x=-start_x;
			bas_x=0;
		}else {
			rap_x=0;
			bas_x = start_x;
		}
		if(start_y<0) {
			rap_y=-start_y;
			bas_y=0;
		}else {
			rap_y=0;
			bas_y = start_y;
		}

		//貼り付けサイズ算出
		area_width  = (rapWidth -rap_x) < (width-bas_x)      ?(rapWidth -rap_x):(width-bas_x);
		area_height = (rapHeight-rap_y) < (getHeight()-bas_y)?(rapHeight-rap_y):(getHeight()-bas_y);

		for(int area_y=0; area_y<area_height; area_y++) {
			for(int area_x=0; area_x<area_width; area_x++) {
				int rap_color = rap_img.getPix((rap_y+area_y)*rapWidth  +  rap_x+area_x);//貼り付け画像での座標
				if(Argb.alpha(rap_color)!=0x00) {
					buffer[(bas_y+area_y)*width  +  bas_x+area_x] =rap_color ;
				}
			}
		}
	}
	public void drawImage2(PixImage rap_img,int start_x,int start_y){
		/**
		 * イメージを書き込みます。(透過)
		 */

		//貼り付け画像
		int rapWidth = rap_img.getWidth();
		int rapHeight = rap_img.getHeight();
		int rap_x = 0;
		int rap_y = 0;

		//基礎画像
		int bas_x=0;
		int bas_y=0;

		//共通(貼り付けサイズ)
		int area_width=0;
		int area_height=0;

		//開始位置算出
		if(start_x<0) {
			rap_x=-start_x;
			bas_x=0;
		}else {
			rap_x=0;
			bas_x = start_x;
		}
		if(start_y<0) {
			rap_y=-start_y;
			bas_y=0;
		}else {
			rap_y=0;
			bas_y = start_y;
		}

		//貼り付けサイズ算出
		area_width  = (rapWidth -rap_x) < (width-bas_x)      ?(rapWidth -rap_x):(width-bas_x);
		area_height = (rapHeight-rap_y) < (getHeight()-bas_y)?(rapHeight-rap_y):(getHeight()-bas_y);

		for(int area_y=0;area_y<area_height;area_y++) {
			for(int area_x=0;area_x<area_width;area_x++) {
				int rap_color = rap_img.getPix((rap_y+area_y)*rapWidth  +  rap_x+area_x);//貼り付け画像での座標
				int base_color= buffer[(bas_y+area_y)*width  +  bas_x+area_x] ;

				//透過
				buffer[(bas_y+area_y)*width  +  bas_x+area_x] = Argb.rap(rap_color, base_color);
			}
		}
	}

}
