//ReadFile_04.java
package map;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.UnsupportedEncodingException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

class ReadFile_04{

  public static int[][] toIntArray2D(
              File inputFile,
              String encoding,
              String delimiters
  ){
      return toIntArray2D(inputFile, encoding, delimiters, 10);
  }

  public static int[][] toIntArray2D(
              File inputFile,
              String encoding,
              String delimiters,
              int radix
  ){
      int[][] array2D = null;

      ArrayList<String> list = fileToList(inputFile, encoding);

      if(list!=null){
          array2D = new int[list.size()][];
          for(int i=0; i< list.size(); i++){
              String[] strArray = list.get(i).split(delimiters);
              int[] intArray = new int[strArray.length];
              try{
                  for(int j=0; j< strArray.length; j++){
                      intArray[j] = Integer.parseInt(strArray[j], radix);
                  }
                  array2D[i] = intArray;
              }catch(NumberFormatException e){
                  e.printStackTrace();
                  return null;
              }
          }
      }else{
          return null;
      }
      return array2D;
  }

  public static ArrayList<ArrayList<String>> toStringList2D(
              File inputFile,
              String encoding,
              String delimiters
  ){
      ArrayList<ArrayList<String>> List2D = null;

      ArrayList<String> list = fileToList(inputFile, encoding);
      if(list!=null){
          List2D = new ArrayList<ArrayList<String>>();
          for(int i=0; i< list.size(); i++){
              String[] line = list.get(i).split(delimiters);
              List2D.add(new ArrayList<String>(Arrays.asList(line)));
          }
      }else{
          return null;
      }
      return List2D;
  }

  public static String[][] toStringArray2D(
              File inputFile,
              String encoding,
              String delimiters
  ){
      String[][] array2D = null;

      ArrayList<String> list = fileToList(inputFile, encoding);
      if(list!=null){
          array2D = new String[list.size()][];
          for(int i=0; i< list.size(); i++){
              array2D[i] = list.get(i).split(delimiters);
          }
      }else{
          return null;
      }
      return array2D;
  }

  public static ArrayList<String> fileToList(
              File inputFile,
              String encoding
  ){
      ArrayList<String> list = null;
      try {
          BufferedReader br = new BufferedReader(
                  new InputStreamReader(
                      new FileInputStream(inputFile), encoding
                  )
          );

          list = new ArrayList<String>();
          String strLine;
          while((strLine = br.readLine()) != null) {

              list.add(strLine);
          }
          br.close();
      } catch (UnsupportedEncodingException e) {
          e.printStackTrace();
      } catch (FileNotFoundException e) {
          e.printStackTrace();
      } catch (IOException e){
          e.printStackTrace();
      } catch (NumberFormatException e){
          e.printStackTrace();
          return null;
      }
      return list;
  }
}
