package point;

public class Compass {
	/**
	 * 		(0,-1)
	 *        0
	 * -PI/2     PI/2
	 *  	  IP
	 *		(0, 1)
	 *
	 * When angle=null return （0,0）
	 * When pos=（0,0）  return null
	 */
	private static Point_dou ANGLE0 = new Point_dou(0,-1);//上が0

	//pos -> angle
	public static double getAngle (double x, double y){

		if(isZero(x, y)){
			//System.out.println("Compass.getAngle(0,0)");
			return Double.NaN;
		}
		//回転方向
		double LR=ANGLE0.x*y-ANGLE0.y*x;//正ならば左回り，負ならば右回り．
		LR = LR<0?-1:+1;//符号化

		//内角
		double cos0=(ANGLE0.x*x + ANGLE0.y*y) /
				(
				Math.sqrt(ANGLE0.x*ANGLE0.x + ANGLE0.y*ANGLE0.y)*
				Math.sqrt(x*x + y*y)
				);
		
		return Math.acos(cos0)*LR;
	}
	public static double getAngle (Point_dou pos){
		return getAngle(pos.x,pos.y);
	}
	//pos -> dist
	public static double getDist(double x, double y){

		return Math.sqrt(x*x+y*y);
	}
	public static double getDist(Point_dou pos){

		return getDist(pos.x, pos.y);
	}
	//angle dist -> pos
	public static Point_dou getPoint (double angle, double dist){

		if(!(angle==angle) || dist<0.01) {
			//angle NaN
			return new Point_dou(0, 0);
		}
		Point_dou pos= rotate(ANGLE0.x, ANGLE0.y, angle);

		pos.x=pos.x*dist;
		pos.y=pos.y*dist;

		//too match small
		//pos.y = Math.abs(pos.y)<0.01?0:pos.y;
		//pos.x = Math.abs(pos.x)<0.01?0:pos.x;
		return pos;

	}
	public static Point_dou sub(Point_dou pos0, Point_dou pos1){
		return new Point_dou(pos1.x-pos0.x, pos1.y-pos0.y);
	}
	
	public static Point_dou add(Point_dou pos0, Point_dou pos1){
		return new Point_dou(pos1.x+pos0.x, pos1.y+pos0.y);
	}
	public static boolean isZero(double x, double y) {
		return x==0 && y==0;
	}
	public static boolean isZero(Point_dou pos) {
		return pos.x==0 && pos.y==0;
	}
//----pos -> pos----------------------------------------------------------------------
	public static Point_dou changeDist(Point_dou pos, double dist) {
		return changeDist(pos.x, pos.y, dist);
	}
	public static Point_dou changeDist(double x, double y, double dist) {
		if(isZero(x, y)){
			double rate = dist/getDist(x, y);
			return new Point_dou(x*rate, y*rate);
		}else{
			return new Point_dou(0,0);
		}
	}
	
	/**
	 *
	 * @param x	回転前の座標
	 * @param y	回転前の座標
	 *
	 * x
	 * |
	 * |
	 * |
	 * |
	 * ----------------y
	 * (0,0)
	 *
	 * @param centerX	回転の中心
	 * @param centerY	回転の中心
	 * @param angle	回転角（左回り　正）
	 * @return
	 */

	public static Point_dou rotate(double x,double y,double centerX,double centerY,double angle){
		if(angle==0){
			return new Point_dou(x,y);
		}else{
			Point_dou temp =rotate(x-centerX, y-centerY, angle);
			return new Point_dou(temp.x+centerX, temp.y+centerY);
		}
	}
	public static Point_dou rotate(Point_dou pos, Point_dou center, double angle){
		return rotate(pos.x, pos.y, center.x, center.y, angle);
	}
	public static Point_dou rotate(double x, double y, double angle){
		if(angle==0){
			return new Point_dou(x, y);
		}else{
			double rotateX=x*Math.cos(angle) - y*Math.sin(angle);
			double rotateY=y*Math.cos(angle) + x*Math.sin(angle);
			return new Point_dou(rotateX, rotateY);
		}
	}
	public static Point_dou rotate(Point_dou pos, double angle){
		return rotate(pos.x, pos.y, angle);
	}

}
