package point;

public class Point_dou {
	/*
	---------------------------------
	|			(0,-1)
	|			angle=0
	|
	|
	|(-1,0)		(0,0)		(1,0)
	|-PI/2     angle=null    PI/2
	|			dist=0
	|
	|			(0,1)
	|			 PI
	|
	*/
	protected double x;

	protected double y;
	
	public Point_dou(){
		this.x=0;
		this.y=0;
	}
	public Point_dou(double x,double y){
		this.x=x;
		this.y=y;
	}
	public Point_dou(Point_dou point){
		this(point.x, point.y);
	}
	public double getX() {
		return x;
	}
	public void setX(double x) {
		this.x = x;
	}
	public double getY() {
		return y;
	}
	public void setY(double y) {
		this.y = y;
	}

	//add
	public void addX(double x){
		this.x += x;
	}
	public void addY(double y){
		this.y += y;
	}
    public void add(double x, double y){
		this.x+=x;
		this.y+=y;
	}
	public void add(Point_dou pos){
		x+=pos.x;
		y+=pos.y;
	}
	
	//-------------------------------------
	//set
    public final void setLocation(Point_dou point) {
    	setLocation(point.getX(), point.getY());
    }
	public void setLocation(double x1, double y1) {
		this.x = x1;
    	this.y = y1;	
	}
	public void setAngle(double angle) {
		if(!Compass.isZero(this)){
			angle=angle%(Math.PI*2);
			Point_dou result=Compass.getPoint(angle, getDist());
			x=result.x;
			y=result.y;
			
		}
	}
	public void setDist(double dist){
		double nowDist=Math.sqrt(x*x+y*y);
		if(!Compass.isZero(this)){
			double rate = dist/nowDist;
			x=x*rate;
			y=y*rate;
		}
	}
	//get
	public Double getAngle() {
		//pos が(0,0)　の場合　null
		return Compass.getAngle(this);
	}
	public double getDist() {
		return Compass.getDist(this);
	}
    //subtract
    public Point_dou getSub(double x2, double y2) {
    	return new Point_dou(x2-x , y2-y);
    }
    public Point_dou getSub(Point_dou vector2) {
    	return new Point_dou(vector2.getX()-x , vector2.getY()-y);
    }
    

	public void addAngle(double angle) {
		Point_dou result=Compass.rotate(x, y, angle);
		x=result.x;
		y=result.y;
	}
	public void addDist(double dist){
		double nowDist=getDist();
		if(nowDist!=0){
			double rate = (dist+nowDist)/nowDist;
			x=x*rate;
			y=y*rate;
		}
	}
	
    //normalize
    public Point_dou getNormalize() {
        final double dist = getDist();

        if (dist == 0.0) {
            return new Point_dou(0.0, 0.0);
        }

        return new Point_dou(x/dist, y/dist);
    }
    
	//boolean
	public boolean isInside(Rect_int rect){
		boolean InsideofArea =
				x <= rect.x+rect.width &&
				x >= rect.x &&
				y <= rect.y+rect.height &&
				y >= rect.y;
		return InsideofArea;
	}
	public Point_dou toInside(Rect_int rect){
		/**
		 * rect の中に移動します。
		 */
		double over_x = 0;
		double over_y = 0;
		//よこ　移動
		double end_x = rect.x + rect.width;
		if(x > end_x) {
			over_x = x - end_x;
    		x = end_x;
    	}else if(x < rect.x) {
    		over_x = x - rect.x;
    		x = rect.x;
    	}

		//たて　移動
    	double end_y = rect.y + rect.height;
    	if(y > end_y) {
    		over_y = y - end_y;
    		y = end_y;
    	}else if(y < rect.y) {
    		over_y = y - rect.y;
    		y = rect.y;
    	}
		return new Point_dou(over_x, over_y);
	}
    public void revX(){
    	//reverse x
    	x = -x;
    }
    public void revY(){
    	//reverse y
    	y = -y;
    }
	public boolean isZero(){
		return Compass.isZero(this);
	}
	public Point_int toInteger(){
		return new Point_int((int)x, (int)y);
	}
	//to
	public void Xto(double target, double step){
		if(x==target)return;
		if(x>target){
			x-=step;
			if(x<target)x=target;
		}
		if(x<target){
			x+=step;
			if(x>target)x=target;
		}
	}
	public void Yto(double target, double step){
		if(y==target)return;
		if(y>target){
			y-=step;
			if(y<target)y=target;
		}
		if(y<target){
			y+=step;
			if(y>target)y=target;
		}
	}
	public static int[] range(int start, int end) {
		int step = end > start ? 1 : -1 ;
		return range(start,end,step);
	}
	public static int[] range(int start, int end, int step) {
		//Python の　range
		int[] arr;
		int area = end - start;
		
		if(area > 0 && step > 0)  {
			//[0, 3, 6, 9]
			int length = area / step;
			length = area % step !=0 ? length+1 : length;
			arr = new int[length];
			int i=0;
			for(int valu = start; valu<end ; valu += step) {
				arr[i] = valu;
				i++;
			}
		}else if(area < 0 && step < 0) {
			//[0, -3, -6, -9]
			int length = area / step;
			length = area % step !=0 ? length+1 : length;
			arr = new int[length];
			int i=0;
			for(int valu = start; valu>end ; valu += step) {
				arr[i] = valu;
				i++;
			}
		}else{
			arr = new int[0];
		}
		
		return arr;
	}
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Point_dou) {
        	Point_dou pd = (Point_dou) obj;
            return (x == pd.x) && (y == pd.y);
        }
        return false;
    }
	@Override
	public String toString(){
		
		return String.format("Point_dou(%4f, %4f)", x,y);
	}
	public static void main(String[] args) {

		System.out.println("");
	}
}
