package point;

public class Rect_int {
	public int x;
	public int y;
	public int width;
	public int height;

	public Rect_int(int x,int y,int width, int height){
		this.x=x;
		this.y=y;
		this.width=width;
		this.height=height;
	}
	public Rect_int(Rect_int r) {
        this(r.x, r.y, r.width, r.height);
    }
	public Rect_int(int width, int height) {
        this(0, 0, width, height);
    }
	public void setBounds(int x, int y, int width, int height) {
		this.x=x;
		this.y=y;
		this.width=width;
		this.height=height;
    }
	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}
	
	public int getWidth() {
		return width;
	}
	public void setWidth(int width) {
		this.width = width;
	}
	public int getHeight() {
		return height;
	}
	public void setHeight(int height) {
		this.height = height;
	}
	
	public double getEndX() {
		return x + width;
	}

	public double getEndY() {
		return y + height;
	}
	
	//center
	public void setCenter(Point_dou center) {
		this.x = (int)(center.x - width/2);
		this.y = (int)(center.y - height/2);
	}
	public Point_dou getCenter(){
		return new Point_dou(x+width/2, y+height/2);
	}
	
	//inside
	public boolean isInside(double pointX, double pointY) {
		return this.x <= pointX && getEndX() > pointX && this.y <= pointY && getEndY() > pointY;
	}
	public boolean isInside(Point_dou point) {
		return isInside(point.getX(), point.getY());
	}
	public boolean toInside(Point_dou point) {
		//point is rerative
		double newX = point.getX();
		double newY = point.getY();
		newX = this.x > newX ? this.x : newX ;
		newX = getEndX()  <=newX ? getEndX()-1 : newX ;
		newY = this.y > newY ? this.y : newY ;
		newY = getEndY()  <=newY ? getEndY()-1 : newY ;
		boolean hit = newX!=point.getX() || newY!=point.getY();
		point.setLocation(newX, newY);
		return hit;
	}
	
	//outside
	public Point_dou toOutside(Rect_int rect) {
		return toOutside(this, rect);
	}
	private static Point_dou toOutside(Rect_int rect1, Rect_int rect2) {
		/*
		 * rect1 move.
		 * */

		final Point_dou r1_center = rect1.getCenter();
		final Point_dou r2_center = rect2.getCenter();
		Point_dou centerVect = r2_center.getSub(r1_center);


		double lap_x;//Negative overlap
		if(centerVect.getX() > 0) {
			//right
			lap_x = rect1.getX() - rect2.getEndX();
			lap_x = lap_x<0 ? -lap_x : 0;//to left
		}else {
			//left
			lap_x = rect2.getX() - rect1.getEndX();
			lap_x = lap_x<0 ? lap_x : 0;//to right
		}

		double lap_y;//Negative overlap
		if(centerVect.getY() < 0) {
			//over
			lap_y = rect2.getY() - rect1.getEndY();
			lap_y = lap_y<0 ? lap_y : 0;//to over
		}else {
			//under
			lap_y = rect1.getY() - rect2.getEndY();
			lap_y = lap_y<0 ? -lap_y : 0;//to under
		}
		Point_dou vect;
		if(Math.abs(lap_x) > Math.abs(lap_y)) {
			vect = new Point_dou(0, (int)lap_y);
		}else {
			vect = new Point_dou((int)lap_x, 0);
		}
		return vect;
		
	}

   @Override
    public boolean equals(Object obj) {
        if (obj instanceof Rect_int) {
        	Rect_int pd = (Rect_int) obj;
            return (x == pd.x) && (y == pd.y) && (width == pd.width) && (height == pd.height);
        }
        return false;
    }
	@Override
	public String toString(){
		
		return String.format("Rect_int(%d, %d, %d, %d)", x, y, width, height);
	}
}
