package screen;

import img.PixImage;
import map.Cell;
import map.Drive;
import point.Point_dou;

public class ScreenImage01 extends ScreenImage{


	int lineColor = 0xffffffff;
	int doorColor = 0xffffffff;
	
	public ScreenImage01(int width, int height) {
		super(width, height);
		center = new Point_dou(width/2, height/2);
		

	}

	private void drawPolygon3D(Point_3D[] vertexArray, int color) {
		Point_dou[] drawPosArray = new Point_dou[vertexArray.length];
		
		for(int i=0; i<vertexArray.length; i++) {
			
			drawPosArray[i] = getDrawPos(vertexArray[i]);
		}
		
		drawPolygon(screen, drawPosArray, color);
	}

	private void drawPolygon3D(Point_3D[] vertexArray, int start, int count ,int color) {
		Point_dou[] drawPosArray = new Point_dou[vertexArray.length];
		
		for(int i=0; i<vertexArray.length; i++) {
			
			drawPosArray[i] = getDrawPos(vertexArray[i]);
		}
		
		drawPolygon(screen, drawPosArray, start, count, color, false);
	}
	public void drawCells(boolean[] shade, int cellPosY) {

		int centerShade = (int)(shade.length/2);
		
		for(int i=0; i<shade.length; i++) {
			
			int cellPosX = (i/2 + i%2) * (i%2*2-1);//  0	1	-1	2	-2	3	-3
			
			Cell cell = Drive.mapper.rotatePosCell(cellPosX, cellPosY);

			if(cell!=null) {
				Point_3D[] vertexArray;
				
				//under upper
				if(cellPosX<2 && cellPosX>-2 && cellPosY==1) {
					int shadeF = centerShade + cellPosX;
					if(!shade[shadeF]) {
						//draw under
						if(cell.getBit4(4)==6) {

							if(cellPosX==0) {
								vertexArray = WallVertex.getUnder(cellPosX, cellPosY);
								drawPolygon3D(vertexArray, lineColor);
							}
							if(cellPosX>0) {
								vertexArray = WallVertex.getUnder(cellPosX, cellPosY);
								drawPolygon3D(vertexArray, 2, 3, lineColor);
							}
							if(cellPosX<0) {
								vertexArray = WallVertex.getUnder(cellPosX, cellPosY);
								drawPolygon3D(vertexArray, 3, 3, lineColor);
							}
						}
						//draw upper
						if(cell.getBit4(4)==7) {

							if(cellPosX==0) {
								vertexArray = WallVertex.getUpper(cellPosX, cellPosY);
								drawPolygon3D(vertexArray, lineColor);
							}
							if(cellPosX>0) {
								vertexArray = WallVertex.getUpper(cellPosX, cellPosY);
								drawPolygon3D(vertexArray, 2, 3, lineColor);
							}
							if(cellPosX<0) {
								vertexArray = WallVertex.getUpper(cellPosX, cellPosY);
								drawPolygon3D(vertexArray, 3, 3, lineColor);
							}
						}
					}
				}
				
				//wall around
				for(int direction=0; direction<4; direction++) {
					if(direction==2)continue;//back side
					
					/*
					 * side
					direction =3 ->left   wall = (-1)
					direction =0 ->center wall = (0)
					direction =1 ->right  wall = (+1)
					 * */
					int side = (2-direction)%2;
					
					
					if(cellPosX<0 && side>0)break;//reverse side
					if(cellPosX>0 && side<0)break;//reverse side
					
					int shadeNo = centerShade + cellPosX + side;// 0-2 0-6
					
					if(shadeNo >= shade.length)break;//out of screen.
					if(shadeNo < 0)break;//out of screen.
					
					if(shade[shadeNo])break;//shade


					//draw wall
					if(cell.getBit4(3-direction)>0) {
						vertexArray = WallVertex.getWall(cellPosX, cellPosY, direction);
						drawPolygon3D(vertexArray, lineColor);
						shade[shadeNo]=true;
					}
					//draw door
					if(cell.getBit4(3-direction)==2) {
						vertexArray = WallVertex.getDoor(cellPosX, cellPosY, direction);
						drawPolygon3D(vertexArray, doorColor);
					}
					
				}

			}else {
				//System.out.println("null");
				/*石の中にいる*/
			}
		}
	}
	@Override
	public PixImage getImage() {

		screen.fill(0xff000000);
		//screen.fillOval((int)center.getX(), (int)center.getY(), 2, 0xffff0000);


		boolean[] shade1 = new boolean[3];

		drawCells(shade1, 0);

		/*
		 Array_length = 5 
		 order of d  | 0 | 1 | 2 | 3 | 4 |
		 ------------------------------------
		 cellPoss2_X | 0 | 1 |-1 | 2 |-2 |
		 shade2_index| 2 | 3 | 1 | 4 | 0 | <- cellPoss2_X + (int)(Array_length/2)
         shade1      |   center  | R | L |
        
		*/
		
		boolean[] shade2 = new boolean[5];
		shade2[0] = shade1[0];//left
		shade2[1] = shade1[1];//center
		shade2[2] = shade1[1];//center
		shade2[3] = shade1[1];//center
		shade2[4] = shade1[2];//right

		drawCells(shade2, 1);
		//screen.waku(0xff666666, 3);
		
		return screen;
	}

}
