package screen;

public class WallVertex {
	
	//draw
	static final double wallX = 0.5;
	static final double wallY = 0.5;
	static final double wallZ = 0.5;
	static final double doorX = 0.3;
	static final double doorY = 0.5;
	static final double doorZ = 0.3;
	
	
	static final Point_3D[] vertexArray1 = {
			new Point_3D( wallX, wallY,  wallZ),
			new Point_3D( wallX, wallY, -wallZ),
			new Point_3D(-wallX, wallY, -wallZ),
			new Point_3D(-wallX, wallY,  wallZ)
	};

	
	static final Point_3D[] vertexArray2 = {
			new Point_3D( doorX, doorY,  wallZ),
			new Point_3D( doorX, doorY, -doorZ),
			new Point_3D(-doorX, doorY, -doorZ),
			new Point_3D(-doorX, doorY,  wallZ)
	};
	
	static final Point_3D[] vertexArray3 = {
			new Point_3D( doorX, doorY,  doorZ),
			new Point_3D( doorX, doorY, -doorZ),
			new Point_3D(-doorX, doorY, -doorZ),
			new Point_3D(-doorX, doorY,  doorZ)
	};
	
    public static Point_3D[] getWall(double x, double y, int direction){
    	//copy
    	Point_3D[] vertexWall = new Point_3D[vertexArray1.length];
		for(int i=0; i<vertexArray1.length; i++ ) {
			vertexWall[i] = vertexArray1[i].clone();
		}
    	//rotate
    	for(int i=0; i<vertexWall.length; i++) {
    		vertexWall[i].rotate90Z(direction);
    	}
		//move
    	for(int i=0; i<vertexWall.length; i++) {
    		vertexWall[i].add(x, y, 0);
    	}
		return vertexWall;
    }
    
    public static Point_3D[] getDoor(double x, double y, int direction){
    	//copy
    	Point_3D[] vertexDoor = new Point_3D[vertexArray2.length];
		for(int i=0; i<vertexArray2.length; i++ ) {
			vertexDoor[i] = vertexArray2[i].clone();
		}
    	//rotate
    	for(int i=0; i<vertexDoor.length; i++) {
    		vertexDoor[i].rotate90Z(direction);
    	}
		//move
    	for(int i=0; i<vertexDoor.length; i++) {
    		vertexDoor[i].add(x, y, 0);
    	}
		return vertexDoor;
    }
    public static Point_3D[] getUnder(double x, double y){
    	//copy
    	Point_3D[] vertexDoor = new Point_3D[vertexArray3.length];
		for(int i=0; i<vertexArray3.length; i++ ) {
			vertexDoor[i] = vertexArray3[i].clone();
		}
    	//rotate
    	for(int i=0; i<vertexDoor.length; i++) {
    		vertexDoor[i].rotateUnder();
    	}
		//move
    	for(int i=0; i<vertexDoor.length; i++) {
    		vertexDoor[i].add(x, y, 0);
    	}
		return vertexDoor;
    }
    public static Point_3D[] getUpper(double x, double y){
    	//copy
    	Point_3D[] vertexDoor = new Point_3D[vertexArray3.length];
		for(int i=0; i<vertexArray3.length; i++ ) {
			vertexDoor[i] = vertexArray3[i].clone();
		}
    	//rotate
    	for(int i=0; i<vertexDoor.length; i++) {
    		vertexDoor[i].rotateUpper();
    	}
		//move
    	for(int i=0; i<vertexDoor.length; i++) {
    		vertexDoor[i].add(x, y, 0);
    	}
		return vertexDoor;
    }
    
    public static void main(String[] args) {
    	Point_3D[] vertexArray = WallVertex.getDoor(0,0,1);
    	for(int i=0; i<vertexArray.length; i++) {
    		System.out.println(vertexArray[i]);
    	}
    }

 
}
