package swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class DialogBlackYN extends JDialog implements KeyListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private int[] key = null;
	private JLabel lab_ans = new JLabel("");
	private int width = 300;
	private int height = 120;
	
	public DialogBlackYN(Frame owner, String title, boolean modal, int[] key){
		super(owner, title, modal);
		this.key = key;
		int x=10;
		int y=10;
		if(owner!=null) {
			x = owner.getX() + owner.getWidth()/2 - width/2;
			y = owner.getY() + owner.getHeight()/2 - height/2;
		}
		setBounds(x, y, width, height);
		Container con = getContentPane();
		addKeyListener(this);
		
		
		JLabel lab_msg = new JLabel(title);
		lab_msg.setPreferredSize(new Dimension(280, 40));
		lab_msg.setForeground(Color.WHITE);
		Font font = new Font("",Font.PLAIN, 16);
		lab_msg.setFont(font);
		lab_msg.setHorizontalAlignment(JLabel.CENTER);
		lab_msg.setVerticalAlignment(JLabel.BOTTOM);
		
		JLabel lab_yn = new JLabel("（y / n）");
		lab_yn.setForeground(Color.WHITE);
		Font font2 = new Font("",Font.PLAIN, 18);
		lab_yn.setFont(font2);

		
		lab_ans.setForeground(Color.WHITE);
		lab_ans.setFont(font2);
		
		JPanel panel = new JPanel() {
			private static final long serialVersionUID = 1L;

			@Override
			public void paintComponent(Graphics g) {
				g.setColor(Color.BLACK);
				g.fillRect(0, 0, getWidth(), getHeight());
				
			}
		};
		LineBorder border = new LineBorder(Color.WHITE, 2, true);
		panel.setBorder(border);
		
		panel.add(lab_msg);
		panel.add(lab_yn);
		panel.add(lab_ans);
		con.add(panel);
		
		setUndecorated(true);
		setVisible(true);
	}
	@Override
	public void keyPressed(KeyEvent e) {
		switch(e.getKeyCode()) {
		case KeyEvent.VK_Y:
			key[0]='y';
			lab_ans.setText("y");
			repaint();
			break;
		case KeyEvent.VK_N:
			key[0]='n';
			lab_ans.setText("n");
			repaint();
			break;
		
		}
	}
	@Override
	public void keyReleased(KeyEvent e) {
		switch(e.getKeyCode()) {
		case KeyEvent.VK_Y:
		case KeyEvent.VK_N:
			try {
				Thread.sleep(500);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			}
			setVisible(false);
		}
	}
	@Override
	public void keyTyped(KeyEvent e) {
		
	}

	public static void main(String[] args) {

		int[] YN = new int[1];
		new DialogBlackYN(null, "上り階段があります。 上りますか？", true, YN);
		System.out.println((char)YN[0]);


	}

}
