package swing;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

import javax.swing.JFrame;

public class FullScreenFrame extends JFrame{

	private static final long serialVersionUID = 1L;
	
	private int x = 10;
	private int y = 10;
	private int width = 400;
	private int height =300;
	private boolean full = false;
	
	public  Container con;

	//constructor
	public FullScreenFrame(String title){
		setTitle(title);
		setBounds(x, y, width, height);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		con = getContentPane();
		setVisible(true);
	}
	public void setBlankCursor() {
		/*Empty cursor image*/
		BufferedImage cursorImage= new BufferedImage(10,10,BufferedImage.TYPE_4BYTE_ABGR);
		Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(), "blank");
		this.setCursor(cursor);
	}
	public void setCursor(BufferedImage cursorImage) {
		/*
		//center
		int w = cursorImage.getWidth();
		int h = cursorImage.getHeight();
		Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(w/2, h/2), "custom");
		*/
		Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(0, 0), "custom");
		this.setCursor(cursor);
	}
	public void setFull() {

		x = getX();
        y = getY();
        width = getWidth();
        height = getHeight();

        dispose();
        setUndecorated(true);//Display window frame
        setBounds(0, 0, getToolkit().getScreenSize().width,
                getToolkit().getScreenSize().height);
        setVisible(true);
        full = true;
	}
	
	public boolean isFull() {
		return full;
	}
	public void setWindow() {
		
		dispose(); 
		setUndecorated(false);//Display window frame
		setBounds(x, y, width, height);
		
		setVisible(true);
		full = false;
	}
	public void change() {
		if(full) {
			setWindow();
		}else {
			setFull();
		}
	}
}

