package map;

public class Cell {
  /*
    0x_76543210
    4bit x 8unit
  */
  private static final int INDEX_F = 3;
  private static final int INDEX_R = 2;
  private static final int INDEX_B = 1;
  private static final int INDEX_L = 0;

  private int value;//4bit x 8unit

  public Cell(int value){
    this.value = value;
  }

  public Cell rotateCell(int direction){
    int r16 = value & 0xffff;
    int l16 = value & 0xffff0000;
    int part1 = r16<<(direction*4)& 0xffff;
    int part2 = r16>>>((4-direction)*4)& 0xffff;
    return new Cell(l16 | part1 | part2);
  }

  public int getValue(){
    return value;
  }
  public int getBit4(int index){
    return value>>>(index*4) & 0xf;
  }
  public int getF(){
    return getBit4(INDEX_F);
  }
  public int getR(){
    return getBit4(INDEX_R);
  }
  public int getB(){
    return getBit4(INDEX_B);
  }
  public int getL(){
    return getBit4(INDEX_L);
  }

  public String toWallString(){

  String form = "  %x  \t^\n%x + %x\t^ Forward\n  %x  \t^";
    String str = String.format(form,
        getBit4(INDEX_F),
        getBit4(INDEX_L),
        getBit4(INDEX_R),
        getBit4(INDEX_B)
    );
    return str;
  }
}
