package map;

import swing.DialogBlackYN;

public class Sample24_02 {


    private final static int NORTH = 0;
    private final static int EAST  = 1;
    private final static int SOUTH = 2;
    private final static int WEST  = 3;

    //actionType cell.getBit4(4)
    //private final static int DOOR_NORTH = 1;
    //private final static int DOOR_EAST  = 2;
    //private final static int DOOR_SOUTH = 3;
    //private final static int DOOR_WEST  = 4;
    private final static int FIELD_MSG  = 5;
    public final static int ACTION_UP  = 6;
    public final static int ACTION_DOWN= 7;

    private int floor = 0;
    private int posX = 0;
    private int posY = 0;
    private int direction = 0;

    private int[][][] map3D = null;

    //cell.getBit4(5)
    private String[] msgArray = null;

    private boolean displayFieldMsg = true;
    private int displayX = 0;
    private int displayY = 0;

    public Sample24_02(
            int[][][] map3D,
            int posX,
            int posY,
            int direction)
    {
      this.map3D = map3D;
      this.posX = posX;
      this.posY = posY;
      this.direction = direction;
    }

    public Sample24_02(int[][][] map3D){
      this.map3D = map3D;
    }

    public void setMsgArray(String[] msgArray){
      this.msgArray = msgArray;
    }
    //Move floor.
    private void up() {
      ++floor;
    }
    private void down() {
      --floor;
    }
    public boolean isOut() {
      return floor < 0;
    }

    //Move field.
    public boolean toForward(){
      Cell cell = rotatePosCell(0, 0);
      boolean pass = cell.getF()!=1;
      if(pass){
        switch(direction){
        case NORTH:
          posY++;
          break;
        case EAST:
          posX++;
          break;
        case SOUTH:
          posY--;
          break;
        case WEST:
          posX--;
          break;
        }

        displayFieldMsg = true;
      }
      return pass;
    }
    public void lookBack(){
      direction += 2;
      direction %= 4;
    }
    public void toRight(){
      direction++;
      direction %= 4;
    }
    public void toLeft(){
      direction--;
      direction += 4;
      direction %= 4;
    }

    //RotateCell
    public Cell rotatePosCell(int x0, int y0){
      //(x0, y0) is relative position.
      int[] xy = rotatePos(x0, y0, direction);
      int[] RC = xytoRC(posX + xy[0], posY + xy[1]);

      Cell cell = null;
      try {
        cell = new Cell(map3D[floor][RC[0]][RC[1]]);
        return cell.rotateCell(direction);
      }catch(java.lang.ArrayIndexOutOfBoundsException e) {
        return cell;
      }
    }
    private int[] xytoRC(int x, int y){
      //(x, y) to Row and Column
      int[] RC = new int[2];
      RC[0]=map3D[floor].length - 1 - y; //Row
      RC[1]=x; //Column
      return RC;
    }

    private static int[] rotatePos(int x0, int y0, int direction) {
      int x;
      int y;

      switch(direction) {
      case NORTH:
        x = x0;
        y = y0;
        break;
      case EAST:
        x = y0;
        y = -x0;
        break;
      case SOUTH:
        x = -x0;
        y = -y0;
        break;
      case WEST:
        x = -y0;
        y = x0;
        break;
      default:
        x = x0;
        y = y0;
      }
      int[] xy = {x, y};
      return xy;
    }

    public String message() {
      if(msgArray==null)return null;

      Cell cell = rotatePosCell(0, 0);
      int type = cell.getBit4(4);

      if(type == 0)return null;

      String msg = null;
      if(type == direction+1) {
        //doorMsg
        int msgNo = cell.getBit4(5);
        msg = msgArray[msgNo];

      }else if(type == FIELD_MSG) {
        //FieldMsg
        if(displayFieldMsg) {
          int msgNo = cell.getBit4(5);
          msg = msgArray[msgNo];
          displayFieldMsg = false;
        }
      }
      return msg;
    }

    public boolean action() {
    Cell cell = rotatePosCell(0, 0);
      int type = cell.getBit4(4);

      switch(type){
        case 0:
            return false;
        case ACTION_DOWN:
            if(displayFieldMsg) {
                /*
                Boolean yn
                  = Scan.getBoolean("上り階段があります。 昇りますか？(Y/N): ");
                if(yn) {
                  down();
                }*/
                int[] YN = new int[1];
                new DialogBlackYN(
                	Drive.frame, "上り階段があります。 上りますか？", true, YN);

                if(YN[0]=='y') {
                  down();
                }
                displayFieldMsg = false;
                return true;
            }
            break;
        case ACTION_UP:
            if(displayFieldMsg) {
                /*
                Boolean yn
                  = Scan.getBoolean("下り階段があります。 降りますか？(Y/N): ");
                if(yn) {
                    up();
                }*/
                int[] YN = new int[1];
                new DialogBlackYN(
                    Drive.frame, "下り階段があります。 降りますか？", true, YN);
                if(YN[0]=='y') {
                  up();
                }
                displayFieldMsg = false;
                return true;
            }
            break;
        }
      return false;
    }

    public String getPos(){
      return String.format("%sF (%2s, %2s) %s",
              Integer.toString(floor+1, 10),
              Integer.toString(posX + displayX, 10),
              Integer.toString(posY + displayY, 10),
              strDirection()
          );
    }
    private String strDirection(){
      switch(direction){
        case NORTH:
          return "NORTH";
        case EAST:
          return "EAST";
        case SOUTH:
          return "SOUTH";
        case WEST:
          return "WEST";
        default:
          return "Invalid direction.";
      }
    }
}
