package screen;

import point.Compass;
import point.Point_dou;

public class Point_3D {

	private static final int directionF = 0;
	private static final int directionR = 1;
	private static final int directionB = 2;
	private static final int directionL = 3;

	protected double x;
	protected double y;
	protected double z;

	public double getX() {
		return x;
	}
	public double getY() {
		return y;
	}
	public double getZ() {
		return z;
	}

	public Point_3D(double x, double y, double z) {
		this.x=x;
		this.y=y;
		this.z=z;
	}
	public Point_3D(double[] xyz) {
		this.x=xyz[0];
		this.y=xyz[1];
		this.z=xyz[2];
	}
	public Point_3D clone() {
		return new Point_3D(x, y, z);
	}
	public Point_3D move(double moveX, double moveY, double angle) {
		/*
		 * input
		 * y(0,1)
		 * |
		 * |
		 * |
		 * |
		 * +---------x(1,0)
		 * (0,0)
		 * */
		Point_dou result = Compass.rotate(x + moveX , y - moveY, angle);
		return new Point_3D(result.getX(), result.getY(), z);
	}
	//add
	public void addX(double x){
		this.x += x;
	}
	public void addY(double y){
		this.y += y;
	}
	public void addZ(double z){
		this.z += z;
	}
    public void add(double x, double y, double z){
		this.x+=x;
		this.y+=y;
		this.z+=z;
	}

    public  void rotate90Z(int direction) {
		double tempX =0;
		switch(direction) {
		case directionF:
			break;
		case directionR:
			tempX = x;
			x = y;
			y = -tempX;
			break;
		case directionB:
			x *= -1;
			y *= -1;
			break;
		case directionL:
			tempX = x;
			x = -y;
			y = tempX;
			break;
		default:
		}
		
	}
    public  void rotateUnder() {
		double tempZ =0;
		tempZ = z;
		z = y;
		y = tempZ;
		
	}
    public  void rotateUpper() {
		double tempZ =0;
		tempZ = z;
		z = -y;
		y = tempZ;
		
	}
	@Override
	public String toString() {
		return String.format("Point_3D(%f, %f, %f)", x,y,z);
		
	}
    public static void main(String[] args) {
    	Point_3D vertex = new Point_3D(0.600000, 0.400000, 0.500000);
    	System.out.println(vertex);
    	vertex.rotate90Z(3);
    	System.out.println(vertex);
    }
}
