package screen;


import img.PixImage;
import point.Point_dou;
import point.Rect_int;


public class ScreenImage {


	protected PixImage screen = null;
	protected int width;
	protected int height;

	public  Rect_int area;
	


	static Point_dou center;
	static final double MAX_ANGLE_PX_RATE = 170;//px
	static final double MAX_ANGLE = Math.PI/3;
	
	public ScreenImage(int width, int height){

		this.width = width;
		this.height = height;
		screen = new PixImage(width, height);
		area = new Rect_int(0, 0, width, height);
		center = new Point_dou(width/2, height/2);
		
	}
	protected void drawPolygon(PixImage pimg, Point_dou[] vertex, int color) {
		drawPolygon(pimg, vertex, 0, vertex.length, color, true);
	}
	
	protected void drawPolygon(PixImage pimg, Point_dou[] vertex, int start, int count, int color , boolean close) {
		for(int i= start; i<start+count-1; i++) {
			PixImage.line(pimg, vertex[i%vertex.length], vertex[(i+1)%vertex.length], color);
		}
		if(close) {
			PixImage.line(pimg, vertex[start], vertex[start+count-1], color);
		}
		
	}
	
	private Point_dou getDrawPos(double x, double y, double z) {
		/*
		 * input
		 * y(0,1)
		 * |
		 * |
		 * |
		 * |
		 * +---------x(1,0)
		 * (0,0)
		 * */
		Point_dou point = new Point_dou(x, -y);
		double dorawX = point.getAngle() / MAX_ANGLE * MAX_ANGLE_PX_RATE + center.getX();
		
		point = new Point_dou(z, -y);
		double dorawY = point.getAngle() / MAX_ANGLE * MAX_ANGLE_PX_RATE + center.getY();
		Point_dou newPoint =new Point_dou(dorawX, dorawY);
		

		
		return newPoint;
	}

	protected Point_dou getDrawPos(Point_3D p3d) {
		return getDrawPos(p3d.getX(), p3d.getY(), p3d.getZ());
	}
	public PixImage getImage() {
		return screen;
		
	};



}
