package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;


public abstract class FullScreenKeyFrame extends FullScreenFrame implements KeyListener{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	protected int key = 0;
	
	public FullScreenKeyFrame(String title) {
		super(title);
		addKeyListener(this);
	}
	public abstract void keyEvent();

	public static void main(String[] args) {
		
		FullScreenKeyFrame frame = new FullScreenKeyFrame("FullScreenKeyFrame") {

			/**
			 * 
			 */
			private static final long serialVersionUID = 1L;

			@Override
			public void keyEvent() {
				System.out.println("key: "+ key);
				
			}
			
		};
		ImagePanel ipanel = new ImagePanel();
		BufferedImage screen = new BufferedImage(400,300,BufferedImage.TYPE_4BYTE_ABGR);
		ipanel.setImage(screen);
		Graphics bg1 = screen.getGraphics();
		
		frame.add(ipanel);
		bg1.setColor(Color.pink);
		bg1.fillRect(0, 0, screen.getWidth(), screen.getHeight());
		bg1.setColor(Color.blue);
		bg1.setFont(new Font("",Font.PLAIN,20));
		bg1.drawString("Press numpadkeys or cursorkeys.", 20, 50 );
		bg1.drawString("echo commandline.", 20, 100 );
		ipanel.repaint();
		frame.setVisible(true);
	}
	@Override
	public void keyPressed(KeyEvent arg0) {
		
		
		switch(arg0.getKeyCode()) {
		case KeyEvent.VK_ESCAPE:
			/*
			setWindow();
			if(threadPanel != null) {
				threadPanel.repaint();
			}else if(menuPanel != null) {
				menuPanel.repaint();
				
			}
			requestFocus();
			*/
			System.exit(0);
			break;
		case KeyEvent.VK_F:
		case KeyEvent.VK_F11:
			//setFull();
			change();

		case KeyEvent.VK_NUMPAD9:
			key = 9;
			break;
		case KeyEvent.VK_UP:
		case KeyEvent.VK_NUMPAD8:
			key = 8;
			break;
		case KeyEvent.VK_NUMPAD7:
			key = 7;
			break;
		case KeyEvent.VK_RIGHT:
		case KeyEvent.VK_NUMPAD6:
			key = 6;
			break;
		case KeyEvent.VK_NUMPAD5:
			key = 5;
			break;
		case KeyEvent.VK_LEFT:
		case KeyEvent.VK_NUMPAD4:
			key = 4;
			break;
		case KeyEvent.VK_NUMPAD3:
			key = 3;
			break;
		case KeyEvent.VK_DOWN:
		case KeyEvent.VK_NUMPAD2:
			key = 2;
			break;
		case KeyEvent.VK_NUMPAD1:
			key = 1;
			break;
		case KeyEvent.VK_NUMPAD0:
			key = 0;
			break;
		case KeyEvent.VK_Y:
			key = 'Y';
			break;
		case KeyEvent.VK_N:
			key = 'N';
			break;

		}
		keyEvent();
	}
	@Override
	public void keyReleased(KeyEvent arg0) {
		key = 999;
	}
	@Override
	public void keyTyped(KeyEvent arg0) {
	}

}
