package swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

import awt.ExchangeImageAWT;
import img.PixImage;
import map.Drive;
import screen.ScreenImage01;

public class FullScreenKeyPimgFrame extends FullScreenKeyFrame{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	
	Color strColor = new Color(0xffefd5);
	Font font1 = new Font("monospace",Font.PLAIN,20);
	Font font2 = new Font("monospace",Font.PLAIN,24);
	Font font3 = new Font("monospace",Font.BOLD ,20);
	
	public ImagePanel ipanel;
	private BufferedImage screen = new BufferedImage(400,300,BufferedImage.TYPE_4BYTE_ABGR);
	Graphics bg1;
	
	ScreenImage01 screenImage;
	int width = 400;
	int height = 300;
	
	public FullScreenKeyPimgFrame(String title) {
		super(title);
		
		ipanel = new ImagePanel();
		
		//ipanel.setBgColor(Color.gray);
		
		con.add(ipanel);
		bg1 = screen.getGraphics();
		ipanel.setImage(screen);
		screenImage = new ScreenImage01(width, height);
		
	}

	private void refreshImage(){
		
		PixImage pimg = screenImage.getImage();
						
		BufferedImage bimg = ExchangeImageAWT.getImage(pimg.getBuffer(), pimg.getWidth());
		bg1.drawImage(bimg, 0, 0, null);
			
		
		bg1.setColor(strColor);
		bg1.setFont(font1);
		bg1.drawString(Drive.mapper.getPos(), 120, 50 );


		ipanel.repaint();
	}
	@Override
	public void keyEvent() {
		boolean pass = true;
		
		switch(key) {
		case 8:
			pass = Drive.mapper.toForward();
			break;
		case 6:
			Drive.mapper.toRight();
			break;
		case 2:
			Drive.mapper.lookBack();
			break;
		case 4:
			Drive.mapper.toLeft();
			break;
			/*
		case 5:
      	  Cell cell = Drive.mapper.rotatePosCell(0, 0);
      	  String WallString = cell.toWallString();
      	  System.out.println(WallString);
            break;
            */
		case 0:
			System.exit(0);
			break;
		}
		refreshImage();
		
		String msg = Drive.mapper.message();

		boolean action = Drive.mapper.action();

        if(Drive.mapper.isOut()) {
        	System.exit(0);
        }
        
		if(action) {
			refreshImage();
		}
		if(msg!=null){
        	bg1.setFont(font3);
        	bg1.drawString(msg, width/2-(msg.length()*font3.getSize()/2), height/3);
        }
		
        if(!pass){
        	bg1.setFont(font2);
        	bg1.drawString("ouch!", width/2-(3*font1.getSize()/2), height/2);
        }
	}

	
	public void iniEvent() {
		
		refreshImage();

	}


}
