package swing;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;


public class ImagePanel extends JPanel{
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
 
	protected Color bgColor = Color.black;
	protected Point mousePosition = new Point(0,0);
	protected BufferedImage bimg;
	
	protected double zoom_ratio;
	protected Rectangle drawArea;


	public void setImage(BufferedImage bimg){
		this.bimg = bimg;
		repaint();
	}
	public void setBgColor(Color color) {
		bgColor = color;
	}
	public Point getPointOnImage(Point panelPoint) {
		Point pointOnPanelImage = new Point(
				panelPoint.x - drawArea.x,
				panelPoint.y - drawArea.y);
		Point pointOnImage = new Point((int)(pointOnPanelImage.x/zoom_ratio),(int)(pointOnPanelImage.y/zoom_ratio));//オリジナルでの座標
		
		return pointOnImage;
	
	}
	
	protected static double zoomRatio(int canvas_width, int canvas_height, int img_width, int img_height) {
		
		double img_aspect = (double)img_height/(double)img_width;//Original Image aspect
		double canvas_aspect = (double)canvas_height/(double)canvas_width;//Paint Area aspect
		boolean boolwidth =canvas_aspect>img_aspect?true:false;// width>height true

		return boolwidth?(double)canvas_width/(double)img_width:
									(double)canvas_height/(double)img_height;
	}
	
	protected static Rectangle getDrawArea(int canvas_width, int canvas_height, int img_width, int img_height, double ratio){
		/**

		-----------------
		|               |
		|               |  canvas_x
		|     canvas    |  canvas_y
		|               |  canvas_width
		|               |  canvas_height
		-----------------
				+
		  -------------
		  |image      |	imgSize.width
		  |      image| imgSize.height
		  -------------

				|		X zoom_ratio
				V
		-----------------
		|---------------|
		|image          | draw_x
		|               | draw_y
		|        image  | draw_width
		|---------------| draw_height
		-----------------

		 *
		 */


		int draw_width =(int) ((double)img_width * ratio);
		int draw_height =(int) ((double)img_height * ratio);

		int draw_x = (int)((canvas_width-draw_width)/2); 
		int draw_y = (int)((canvas_height-draw_height)/2); 

		return new Rectangle(draw_x, draw_y, draw_width, draw_height);

	}
	
	@Override
	public void paintComponent(Graphics g){
		Graphics2D g2 = (Graphics2D)g;
		//memo 図形や線のアンチエイリアシングの有効化
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		//memo 図形や線のアンチエイリアシングの有効化
		//g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
		g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);

		if(bimg==null)return;

		/*memo panel上　での　イメージ書き出し位置（x,y）　と　描画サイズ（W,H）*/
		zoom_ratio = zoomRatio(getWidth(), getHeight(), bimg.getWidth(), bimg.getHeight());
		drawArea = getDrawArea(getWidth(), getHeight(), bimg.getWidth(), bimg.getHeight(), zoom_ratio);

		g2.setColor(bgColor);
		g2.fillRect(0, 0, getWidth(), getHeight());
		g2.drawImage(bimg, drawArea.x, drawArea.y,drawArea.width ,drawArea.height,this);
		//g2.drawImage(bimg, 0, 0,this.getWidth() ,this.getHeight(),this);//

	}

}